class DanesUT_Invisibility extends UT_Invisibility;

var sound PickupSound;

state Activated
{
	function endstate()
	{
		local Inventory S;

		bActive = false;		
		PlaySound(DeActivateSound);

		Owner.SetDefaultDisplayProperties();
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			UT_Shieldbelt(S).MyEffect.bHidden = false;
	}

	function Activate()
	{
		bActive = true;
		SetOwnerDisplay();
	}

	function SetOwnerDisplay()
	{
		if ( !bActive )
			return;
		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent, 
							 FireTexture'unrealshare.Belt_fx.Invis',
							 true,
							 true);
		if( Inventory != None )
			Inventory.SetOwnerDisplay();
	}

	function ChangedWeapon()
	{
		if ( !bActive )
			return;
		if( Inventory != None )
			Inventory.ChangedWeapon();

		// Make new weapon invisible.
		if ( Pawn(Owner).Weapon != None )
			Pawn(Owner).Weapon.SetDisplayProperties(ERenderStyle.STY_Translucent, 
									 FireTexture'Unrealshare.Belt_fx.Invis',
									 true,
									 true);
	}

	function Timer()
	{
		Charge -= 1;
		Pawn(Owner).Visibility = 10;
		if (Charge<-0)
			UsedUp();
	}

	function BeginState()
	{
		local Inventory S;

		bActive = true;
		PlaySound(ActivateSound,,4.0);

		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent, 
								   FireTexture'unrealshare.Belt_fx.Invis',
								   false,
								   true);
		SetTimer(0.5,True);
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			UT_Shieldbelt(S).MyEffect.bHidden = true;
	}
}

state DeActivated
{
Begin:
}

defaultproperties
{
     ExpireMessage="Invisibility has worn off."
     bAutoActivate=True
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You have Invisibility."
     ItemName="Invisibility"
     RespawnTime=120.000000
     PickupViewMesh=LodMesh'Botpack.invis2M'
     Charge=100
     MaxDesireability=1.200000
     ActivateSound=Sound'UnrealI.Pickups.Invisible'
     RemoteRole=ROLE_DumbProxy
     Texture=FireTexture'UnrealShare.Belt_fx.Invis.Invis'
     Mesh=LodMesh'Botpack.invis2M'
     CollisionRadius=15.000000
     CollisionHeight=20.000000
}
